package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 4/4/21.
 */
public abstract class Unary extends Instruction {

    protected InstructionSlot<Instruction> argument;

    protected Unary(InsnOpcode opcode, Instruction argument) {
        super(opcode);
        this.argument = new InstructionSlot<>(this);
        setArgument(argument);
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    //@formatter:off
    public Instruction getArgument() { return argument.get(); }
    public void setArgument(Instruction argument) { this.argument.set(argument); }
    //@formatter:on
}
