package net.covers1624.coffeegrinder.source;

/**
 * Created by covers1624 on 14/8/21.
 */
public class EscapeUtils {

    /**
     * Escape all non-ascii or control code characters in a string.
     *
     * @param string The string.
     * @return The new String.
     */
    public static String escapeChars(String string) {
        int i = 0;
        char[] chars = string.toCharArray();
        while (i < chars.length && !needsEscape(chars[i])) {
            i++;
        }
        // We have no escapable characters.
        if (i == chars.length) return string;

        StringBuilder sb = new StringBuilder(string.substring(0, i));
        for (; i < chars.length; i++) {
            sb.append(escapeChar(chars[i], false));
        }
        return sb.toString();
    }

    public static String escapeChar(char ch) {
        return escapeChar(ch, true);
    }

    private static String escapeChar(char ch, boolean charLiteral) {
        switch (ch) {
            //@formatter:off
            case '\t': return "\\t";
            case '\b': return "\\b";
            case '\n': return "\\n";
            case '\r': return "\\r";
            case '\f': return "\\f";
            case '\'': return charLiteral ? "\\'" : Character.toString(ch);
            case '\"': return "\\\"";
            case '\\': return "\\\\";
            //@formatter:on
        }
        if (isAscii(ch)) return Character.toString(ch);

        return String.format("\\u%04X", ((int) ch) & 0xFFFF);
    }

    private static boolean needsEscape(char ch) {
        if (!isAscii(ch)) return true;

        switch (ch) {
            case '\t':
            case '\b':
            case '\n':
            case '\r':
            case '\f':
            case '\'':
            case '\"':
            case '\\':
                return true;
            default:
                return false;
        }
    }

    private static boolean isAscii(char ch) {
        return ch >= 32 && ch < 127;
    }
}
