package net.covers1624.coffeegrinder.type;

import com.google.common.collect.ImmutableList;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

import java.util.List;

/**
 * Created by covers1624 on 21/12/23.
 */
public class ArrayCloneMethod extends Method {

    private final ArrayType type;

    public ArrayCloneMethod(ArrayType type) {
        this.type = type;
    }

    // @formatter:off
    @Override public List<TypeParameter> getTypeParameters() { return ImmutableList.of(); }
    @Override public ClassType getDeclaringClass() { return TypeSystem.objectType(type); }
    @Override public String getName() { return "clone"; }
    @Override public AType getReturnType() { return type; }
    @Override public List<Parameter> getParameters() { return ImmutableList.of(); }
    @Override public List<ReferenceType> getExceptions() { return ImmutableList.of(); }
    @Override public EnumBitSet<AccessFlag> getAccessFlags() { return EnumBitSet.of(AccessFlag.PUBLIC); }
    @Override public Type getDescriptor() { throw new NotImplementedException("Meh?"); }
    @Override public @Nullable Object getDefaultAnnotationValue() { return null; }
    @Override public Method getDeclaration() { return this; }
    @Override public Method asRaw() { throw new UnsupportedOperationException(); }
    @Override public boolean isConstructor() { return false; }
    // @formatter:on
}
