package net.covers1624.coffeegrinder.util;

import com.google.common.base.Suppliers;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

/**
 * Created by covers1624 on 23/2/21.
 */
public class Util {

    public static <T> void reverse(List<T> list) {
        for (int i = 0, j = list.size() - 1; i < j; i++, j--) {
            T tmp = list.get(i);
            list.set(i, list.get(j));
            list.set(j, tmp);
        }
    }

    public static <T> Iterable<T> safeConcat(@Nullable List<T> a, @Nullable List<T> b) {
        if (a != null && b != null) return FastStream.concat(a, b);

        return a == null ? b != null ? b : FastStream.of() : a;
    }

    public static <T> Supplier<T> singleMemoize(Supplier<T> supplier) {
        AtomicBoolean hit = new AtomicBoolean();
        return Suppliers.memoize(() -> {
            if (hit.get()) throw new RuntimeException("Memoized supplier re-enterance detected.");

            hit.set(true);
            return supplier.get();
        });
    }
}
