package net.covers1624.coffeegrinder.util.asm;

import com.google.common.collect.ImmutableList;
import net.covers1624.coffeegrinder.type.ITypeParameterizedMember;
import net.covers1624.coffeegrinder.type.asm.AsmTypeParameter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

import java.util.List;

/**
 * Created by covers1624 on 23/12/21.
 */
public class TypeParameterParser {

    public static List<AsmTypeParameter> parse(String sig, ITypeParameterizedMember owner) {
        ImmutableList.Builder<AsmTypeParameter> parameters = ImmutableList.builder();
        new SignatureReader(sig).accept(new SignatureVisitor(Opcodes.ASM9) {
            private int index;

            @Override
            public void visitFormalTypeParameter(String name) {
                parameters.add(new AsmTypeParameter(name, index++, owner));
            }
        });
        return parameters.build();
    }
}
