/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.testframework.javac;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.covers1624.coffeegrinder.testframework.common.BaseTestInstanceContext;
import net.covers1624.coffeegrinder.testframework.javac.MainJavacContext;
import net.covers1624.coffeegrinder.testframework.javac.node.CompileNode;

public class JavacTestCaseInstanceContext
extends BaseTestInstanceContext<MainJavacContext> {
    public final Path testInptDir;
    public final List<String> files;
    public final Path testInputRoot;
    public final Path javacPath;
    public final Path initialCompileOutput;
    public final Path outputSource;
    public final Path reCompileOutput;

    public JavacTestCaseInstanceContext(MainJavacContext mainContext, Path testInptDir, List<String> files) throws IOException {
        super(mainContext);
        this.testInptDir = testInptDir;
        this.files = files;
        this.testInputRoot = mainContext.testInputRoot;
        this.javacPath = mainContext.javacPath;
        this.initialCompileOutput = Files.createTempDirectory("gc_javac_initial_", new FileAttribute[0]);
        this.initialCompileOutput.toFile().deleteOnExit();
        this.outputSource = mainContext.sourceOutput.resolve(this.testInputRoot.relativize(testInptDir));
        Files.createDirectories(this.outputSource, new FileAttribute[0]);
        this.reCompileOutput = Files.createTempDirectory("gc_javac_recompile_", new FileAttribute[0]);
        this.reCompileOutput.toFile().deleteOnExit();
    }

    public List<String> getFiles(CompileNode.CompileType type) {
        return type == CompileNode.CompileType.INITIAL ? this.files : this.computeRecompSources();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> computeRecompSources() {
        try (Stream<Path> files = Files.walk(this.outputSource, new FileVisitOption[0]);){
            List<String> list = files.filter(e -> e.getFileName().toString().endsWith(".java")).map(this.outputSource::relativize).map(Path::toString).collect(Collectors.toList());
            return list;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to iterate files.", ex);
        }
    }
}

