/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.testframework.testcase.util;

import com.google.gson.FormattingStyle;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import net.covers1624.coffeegrinder.testframework.api.Target;
import net.covers1624.coffeegrinder.testframework.testcase.TestCase;
import net.covers1624.quack.gson.JsonUtils;
import net.covers1624.quack.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class LibraryTestCaseDef {
    private static final Gson GSON = new GsonBuilder().setFormattingStyle(FormattingStyle.PRETTY.withNewline(System.lineSeparator()).withIndent("    ")).disableHtmlEscaping().create();
    public final Map<String, TestCaseDef> cases = new LinkedHashMap<String, TestCaseDef>();

    public TestCaseDef get(String cName) {
        return this.cases.getOrDefault(cName, new TestCaseDef());
    }

    public static LibraryTestCaseDef load(@Nullable Path path) throws IOException {
        if (path == null || Files.notExists(path, new LinkOption[0])) {
            return new LibraryTestCaseDef();
        }
        return (LibraryTestCaseDef)JsonUtils.parse((Gson)GSON, (Path)path, LibraryTestCaseDef.class);
    }

    public void save(Path path) throws IOException {
        JsonUtils.write((Gson)GSON, (Path)IOUtils.makeParents((Path)path), (Object)this);
    }

    public static class BrokenDef {
        @Nullable
        public String exception;
        public boolean ignoreMessage = false;
        @Nullable
        public String message;
        public String @Nullable [] stackTrace;

        public TestCase.BrokenData buildData() {
            try {
                return new TestCase.BrokenData(Class.forName(this.exception.replace('/', '.')), this.ignoreMessage, this.message);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Exception class does not exist.", ex);
            }
        }
    }

    public static class TestCaseDef {
        @Nullable
        public Target target;
        @Nullable
        public BrokenDef broken;
        @Nullable
        public Map<String, String> roundTripIgnore;
    }
}

