/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.testframework.javac.node;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.covers1624.coffeegrinder.testframework.common.node.ChildDescriptor;
import net.covers1624.coffeegrinder.testframework.javac.JavacTestCaseInstanceContext;
import net.covers1624.quack.util.ProcessUtils;
import net.covers1624.quack.util.SneakyUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;

public class CompileNode
extends ChildDescriptor<JavacTestCaseInstanceContext> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CompileType type;

    public CompileNode(UniqueId parentId, String displayName, CompileType type) {
        super(parentId.append("name", displayName), displayName);
        this.type = type;
    }

    public JavacTestCaseInstanceContext execute(JavacTestCaseInstanceContext context, Node.DynamicTestExecutor dynamicTestExecutor) throws Exception {
        ArrayList<String> javacLog = new ArrayList<String>();
        int javacExit = CompileNode.runProcess(builder -> {
            builder.directory((this.type == CompileType.INITIAL ? context.testInptDir : context.outputSource).toFile());
            LinkedList<String> command = new LinkedList<String>();
            command.add(context.javacPath.toAbsolutePath().toString());
            command.add("-g");
            command.add("-d");
            command.add((this.type == CompileType.INITIAL ? context.initialCompileOutput : context.reCompileOutput).toAbsolutePath().toString());
            command.addAll(context.getFiles(this.type));
            builder.command(command);
        }, javacLog);
        if (javacExit != 0) {
            System.err.println("Compile failed: ");
            for (String s : javacLog) {
                System.err.println(s);
            }
            throw new Exception("Javac exitied with status " + javacExit + ":\n\n" + String.join((CharSequence)"\n", javacLog));
        }
        return context;
    }

    private static int runProcess(Consumer<ProcessBuilder> configure, List<String> log) throws IOException {
        ProcessBuilder procBuilder = new ProcessBuilder(new String[0]);
        configure.accept(procBuilder);
        procBuilder.redirectErrorStream(true);
        Process process = procBuilder.start();
        CompletableFuture<Void> stdoutFuture = CompileNode.processLines(process.getInputStream(), log::add);
        ProcessUtils.onExit((Process)process).thenRunAsync(() -> {
            if (!stdoutFuture.isDone()) {
                stdoutFuture.cancel(true);
            }
        });
        try {
            process.waitFor();
        }
        catch (InterruptedException ex) {
            LOGGER.error("Interrupted.", (Throwable)ex);
        }
        return process.exitValue();
    }

    private static CompletableFuture<Void> processLines(InputStream stream, Consumer<String> consumer) {
        return CompletableFuture.runAsync(SneakyUtils.sneak(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    consumer.accept(line);
                }
            }
        }));
    }

    public static enum CompileType {
        INITIAL,
        RECOMP;

    }
}

