/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.testframework.testcase;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.covers1624.coffeegrinder.testframework.api.Broken;
import net.covers1624.coffeegrinder.testframework.api.DecompileTest;
import net.covers1624.coffeegrinder.testframework.api.Target;
import org.jetbrains.annotations.Nullable;

public class TestCase {
    public final String className;
    public final Target target;
    @Nullable
    public final BrokenData brokenData;
    public final Map<String, Map<String, String>> roundTripIgnores;
    @Nullable
    public Target reachedTarget;
    @Nullable
    public BrokenData processingError;
    public Map<String, Map<String, String>> appliedRoundTripIgnores = new LinkedHashMap<String, Map<String, String>>();

    public TestCase(String className, Target target, @Nullable BrokenData brokenData, Map<String, Map<String, String>> roundTripIgnores) {
        this.className = className;
        this.target = target;
        this.brokenData = brokenData;
        this.roundTripIgnores = roundTripIgnores;
    }

    public String path() {
        return this.className.replace('.', '/');
    }

    public Collection<String> getRoundTripIgnores(String cName) {
        return this.roundTripIgnores.getOrDefault(cName, (Map<String, String>)ImmutableMap.of()).keySet();
    }

    public static class BrokenData {
        public final Class<? extends Throwable> expected;
        public final boolean ignoreExceptionMessages;
        @Nullable
        public final String message;
        @Nullable
        public final String stackTrace;

        public BrokenData(Broken broken) {
            this(broken.expected(), broken.ignoreExceptionMessage(), broken.message().length != 0 ? String.join((CharSequence)"\n", broken.message()) : null);
        }

        public BrokenData(Class<? extends Throwable> expected, boolean ignoreExceptionMessages, @Nullable String message) {
            this(expected, ignoreExceptionMessages, message, null);
        }

        public BrokenData(Class<? extends Throwable> expected, boolean ignoreExceptionMessages, @Nullable String message, @Nullable String stackTrace) {
            this.expected = expected;
            this.ignoreExceptionMessages = ignoreExceptionMessages;
            this.message = message;
            this.stackTrace = stackTrace;
        }

        @Nullable
        public static BrokenData from(DecompileTest test) {
            Broken[] annotations = test.broken();
            if (annotations.length == 0) {
                return null;
            }
            if (annotations.length > 1) {
                throw new IllegalArgumentException("More than one Broken annotation.");
            }
            return new BrokenData(annotations[0]);
        }
    }
}

