/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.diffpatch.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class LineRange {
    private int start;
    private int end;

    public LineRange() {
    }

    public LineRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public boolean contains(int i) {
        return this.start <= i && i < this.end;
    }

    public boolean contains(LineRange r) {
        return r.start >= this.start && r.end <= this.end;
    }

    public boolean intersects(LineRange r) {
        return r.start < this.end || r.end > this.start;
    }

    public LineRange add(int i) {
        return new LineRange(this.start + i, this.end + i);
    }

    public LineRange sub(int i) {
        return new LineRange(this.start - i, this.end - i);
    }

    public List<LineRange> except(List<LineRange> except) {
        return this.except(except, false);
    }

    public List<LineRange> except(List<LineRange> except, boolean presorted) {
        if (!presorted) {
            except = new ArrayList<LineRange>(except);
            except.sort(Comparator.comparingInt(e -> e.start));
        }
        ArrayList<LineRange> ret = new ArrayList<LineRange>();
        int start = this.start;
        for (LineRange r : except) {
            if (r.start - start > 0) {
                ret.add(new LineRange(start, r.start));
            }
            start = r.end;
        }
        if (this.end - start > 0) {
            ret.add(new LineRange(start, this.end));
        }
        return ret;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public void setLength(int len) {
        this.end = this.start + len;
    }

    public int getLast() {
        return this.end - 1;
    }

    public void setLast(int last) {
        this.end = last + 1;
    }

    public int getFirst() {
        return this.getStart();
    }

    public void setFirst(int first) {
        this.setStart(first);
    }

    public static LineRange fromFirstLast(int first, int last) {
        LineRange range = new LineRange();
        range.setFirst(first);
        range.setLast(last);
        return range;
    }

    public static LineRange fromStartLen(int start, int len) {
        LineRange range = new LineRange();
        range.setStart(start);
        range.setLength(len);
        return range;
    }

    public static LineRange union(LineRange r1, LineRange r2) {
        return new LineRange(Math.min(r1.start, r2.start), Math.max(r1.end, r2.end));
    }

    public static LineRange intersection(LineRange r1, LineRange r2) {
        return new LineRange(Math.max(r1.start, r2.start), Math.min(r1.end, r2.end));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineRange lineRange = (LineRange)o;
        if (this.getStart() != lineRange.getStart()) {
            return false;
        }
        return this.getEnd() == lineRange.getEnd();
    }

    public int hashCode() {
        int result = this.getStart();
        result = 31 * result + this.getEnd();
        return result;
    }

    public String toString() {
        return "[" + this.start + "," + this.end + ")";
    }
}

