/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.AbstractGraphvizEngine;
import guru.nidi.graphviz.engine.Communicator;
import guru.nidi.graphviz.engine.EngineResult;
import guru.nidi.graphviz.engine.GraphvizEngine;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.GraphvizServer;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.engine.Rasterizer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class GraphvizServerEngine
extends AbstractGraphvizEngine {
    private final List<GraphvizEngine> engines = new ArrayList<GraphvizEngine>();
    private String host = "localhost";
    private int port = 10234;

    public GraphvizServerEngine() {
        super(false);
    }

    public GraphvizServerEngine useEngine(GraphvizEngine first, GraphvizEngine ... rest) {
        this.engines.clear();
        this.engines.add(first);
        this.engines.addAll(Arrays.asList(rest));
        return this;
    }

    public GraphvizServerEngine port(int port) {
        this.port = port;
        return this;
    }

    public GraphvizServerEngine host(String host) {
        this.host = host;
        return this;
    }

    public GraphvizServerEngine timeout(int amount, TimeUnit unit) {
        return (GraphvizServerEngine)super.timeout(amount, unit);
    }

    @Override
    public EngineResult execute(String src, Options options, Rasterizer rasterizer) {
        try {
            return EngineResult.fromString(this.createSvg(src, options));
        }
        catch (SocketTimeoutException e) {
            throw new GraphvizException("Engine took too long to respond, try setting a higher timout");
        }
        catch (IOException e) {
            throw new GraphvizException("Problem in communication with GraphvizServer at " + this.host + ":" + this.port, e);
        }
    }

    @Override
    protected void doInit() throws IOException {
        if (!this.canConnect()) {
            if (!InetAddress.getByName(this.host).isLoopbackAddress()) {
                throw new IOException("Could not connect to GraphvizServer at " + this.host + ":" + this.port);
            }
            GraphvizServer.start(this.engines, this.port);
            for (int i = 0; i < 100 && !this.canConnect(); ++i) {
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.canConnect()) {
                throw new IOException("Could not connect to GraphvizServer at " + this.host + ":" + this.port);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canConnect() {
        try (Socket socket = GraphvizServerEngine.socket(this.host, this.port);){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private String createSvg(String src, Options options) throws IOException {
        return GraphvizServerEngine.communicating(this.host, this.port, this.timeout, com -> {
            com.writeContent(options.toJson(true) + "@@@" + src);
            String status = com.readStatus();
            int len = com.readLen();
            String content = com.readContent(len);
            if (!"ok".equals(status)) {
                throw new GraphvizException(content);
            }
            return content;
        });
    }

    public void stopThisServer() {
        GraphvizServerEngine.stopServer(this.host, this.port);
    }

    public static void stopServer() {
        GraphvizServerEngine.stopServer(10234);
    }

    public static void stopServer(int port) {
        GraphvizServerEngine.stopServer("localhost", port);
    }

    public static void stopServer(String host, int port) {
        try {
            GraphvizServerEngine.communicating(host, port, 5000, com -> {
                com.writeLen(-1);
                return "";
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    private static <T> T communicating(String host, int port, int timeout, ComFunc<T> action) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Socket socket(String host, int port) throws IOException {
        Socket socket = new Socket();
        socket.setSoTimeout(500);
        socket.connect(new InetSocketAddress(host, port), 500);
        return socket;
    }

    private static interface ComFunc<T> {
        public T apply(Communicator var1) throws IOException;
    }
}

