/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Optional;
import org.junit.platform.console.options.BaseCommand;
import org.junit.platform.console.options.TestConsoleOutputOptions;
import org.junit.platform.console.options.TestConsoleOutputOptionsMixin;
import org.junit.platform.console.options.TestDiscoveryOptions;
import org.junit.platform.console.options.TestDiscoveryOptionsMixin;
import org.junit.platform.console.shadow.picocli.CommandLine;
import org.junit.platform.console.tasks.ConsoleTestExecutor;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

@CommandLine.Command(name="execute", description={"Execute tests"})
class ExecuteTestsCommand
extends BaseCommand<TestExecutionSummary>
implements CommandLine.IExitCodeGenerator {
    private static final int TEST_FAILED = 1;
    private static final int NO_TESTS_FOUND = 2;
    private final ConsoleTestExecutor.Factory consoleTestExecutorFactory;
    @CommandLine.Mixin
    TestDiscoveryOptionsMixin discoveryOptions;
    @CommandLine.Mixin
    TestConsoleOutputOptionsMixin testOutputOptions;
    @CommandLine.ArgGroup(validate=false, order=6, heading="%n@|bold REPORTING|@%n%n")
    ReportingOptions reportingOptions;

    ExecuteTestsCommand(ConsoleTestExecutor.Factory consoleTestExecutorFactory) {
        this.consoleTestExecutorFactory = consoleTestExecutorFactory;
    }

    @Override
    protected TestExecutionSummary execute(PrintWriter out) {
        return this.consoleTestExecutorFactory.create(this.toTestDiscoveryOptions(), this.toTestConsoleOutputOptions()).execute(out, this.getReportsDir());
    }

    Optional<Path> getReportsDir() {
        return this.getReportingOptions().flatMap(ReportingOptions::getReportsDir);
    }

    private Optional<ReportingOptions> getReportingOptions() {
        return Optional.ofNullable(this.reportingOptions);
    }

    TestDiscoveryOptions toTestDiscoveryOptions() {
        return this.discoveryOptions == null ? new TestDiscoveryOptions() : this.discoveryOptions.toTestDiscoveryOptions();
    }

    TestConsoleOutputOptions toTestConsoleOutputOptions() {
        TestConsoleOutputOptions testOutputOptions = this.testOutputOptions.toTestConsoleOutputOptions();
        testOutputOptions.setAnsiColorOutputDisabled(this.ansiColorOption.isDisableAnsiColors());
        return testOutputOptions;
    }

    @Override
    public int getExitCode() {
        TestExecutionSummary executionResult = (TestExecutionSummary)this.commandSpec.commandLine().getExecutionResult();
        boolean failIfNoTests = this.getReportingOptions().map(it -> ((ReportingOptions)it).failIfNoTests).orElse(false);
        if (failIfNoTests && executionResult.getTestsFoundCount() == 0L) {
            return 2;
        }
        return executionResult.getTotalFailureCount() == 0L ? 0 : 1;
    }

    static class ReportingOptions {
        @CommandLine.Option(names={"--fail-if-no-tests"}, description={"Fail and return exit status code 2 if no tests are found."})
        private boolean failIfNoTests;
        @CommandLine.Option(names={"--reports-dir"}, paramLabel="DIR", description={"Enable report output into a specified local directory (will be created if it does not exist)."})
        private Path reportsDir;
        @CommandLine.Option(names={"-reports-dir"}, hidden=true)
        private Path reportsDir2;

        ReportingOptions() {
        }

        Optional<Path> getReportsDir() {
            return this.reportsDir == null ? Optional.ofNullable(this.reportsDir2) : Optional.of(this.reportsDir);
        }
    }
}

