/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.AttributeValueEscapingWriter;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.Element;

class EscapingXMLStreamWriter
implements XMLStreamWriter {
    static final char ILLEGAL_CHARACTER_REPLACEMENT = '\ufffd';
    private final AttributeValueEscapingWriter out;
    private final XMLStreamWriter delegate;

    EscapingXMLStreamWriter(AttributeValueEscapingWriter out, XMLStreamWriter delegate) {
        this.out = out;
        this.delegate = delegate;
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.delegate.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.delegate.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.delegate.writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.delegate.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.delegate.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.delegate.writeEmptyElement(localName);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.delegate.writeEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.delegate.writeEndDocument();
    }

    @Override
    public void close() throws XMLStreamException {
        this.delegate.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.delegate.flush();
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.withWhitespaceReplacingEnabled(() -> this.delegate.writeAttribute(localName, EscapingXMLStreamWriter.replaceIllegalCharacters(value)));
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.withWhitespaceReplacingEnabled(() -> this.delegate.writeAttribute(prefix, namespaceURI, localName, EscapingXMLStreamWriter.replaceIllegalCharacters(value)));
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.withWhitespaceReplacingEnabled(() -> this.delegate.writeAttribute(namespaceURI, localName, EscapingXMLStreamWriter.replaceIllegalCharacters(value)));
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.delegate.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.delegate.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        if (!Element.CDATA_WORKAROUND_COMMENT.equals(data)) {
            this.delegate.writeComment(EscapingXMLStreamWriter.replaceIllegalCharacters(data));
        }
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.delegate.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.delegate.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.delegate.writeCData(EscapingXMLStreamWriter.replaceIllegalCharacters(data));
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.delegate.writeDTD(dtd);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.delegate.writeEntityRef(name);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.delegate.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.delegate.writeStartDocument(version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.delegate.writeStartDocument(encoding, version);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.delegate.writeCharacters(EscapingXMLStreamWriter.replaceIllegalCharacters(text));
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.writeCharacters(new String(text, start, len));
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.delegate.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.delegate.setPrefix(prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.delegate.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.delegate.setNamespaceContext(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.delegate.getNamespaceContext();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.delegate.getProperty(name);
    }

    private static String replaceIllegalCharacters(String text) {
        if (text.codePoints().allMatch(EscapingXMLStreamWriter::isAllowedXmlCharacter)) {
            return text;
        }
        StringBuilder result = new StringBuilder(text.length() * 2);
        text.codePoints().forEach(codePoint -> {
            if (EscapingXMLStreamWriter.isAllowedXmlCharacter(codePoint)) {
                result.appendCodePoint(codePoint);
            } else {
                result.append('\ufffd');
            }
        });
        return result.toString();
    }

    private static boolean isAllowedXmlCharacter(int codePoint) {
        return codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 32 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF;
    }

    private void withWhitespaceReplacingEnabled(XmlStreamOperation operation) throws XMLStreamException {
        this.delegate.flush();
        this.out.setWhitespaceReplacingEnabled(true);
        operation.execute();
        this.delegate.flush();
        this.out.setWhitespaceReplacingEnabled(false);
    }

    @FunctionalInterface
    private static interface XmlStreamOperation {
        public void execute() throws XMLStreamException;
    }
}

