/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import java.util.Iterator;
import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionCollection;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.SemanticHelper;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.TryInstruction;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public class TryCatch
extends TryInstruction {
    private final InstructionSlot<BlockContainer> tryBody = new InstructionSlot(this);
    public final InstructionCollection<TryCatchHandler> handlers = new InstructionCollection(this);

    public TryCatch(BlockContainer tryBody) {
        super(InsnOpcode.TRY_CATCH);
        this.setTryBody(tryBody);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    protected EnumBitSet<InstructionFlag> computeFlags() {
        EnumBitSet<InstructionFlag> flags = this.getTryBody().getFlags().copy();
        Iterator<TryCatchHandler> iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            TryCatchHandler handler = iterator.next();
            flags = SemanticHelper.combineBranches(flags, handler.getFlags());
        }
        return flags;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitTryCatch(this, ctx);
    }

    @Override
    public BlockContainer getTryBody() {
        return this.tryBody.get();
    }

    @Override
    public void setTryBody(BlockContainer tryBody) {
        this.tryBody.set(tryBody);
    }

    public static class TryCatchHandler
    extends Instruction {
        private final InstructionSlot<LocalReference> variable = new InstructionSlot(this);
        private final InstructionSlot<BlockContainer> body = new InstructionSlot(this);
        public boolean isUnprocessedFinally = false;

        public TryCatchHandler(BlockContainer body, LocalReference variable) {
            super(InsnOpcode.TRY_CATCH_HANDLER);
            this.variable.set(variable);
            this.body.set(body);
        }

        @Override
        public AType getResultType() {
            return PrimitiveType.VOID;
        }

        @Override
        public EnumBitSet<InstructionFlag> getDirectFlags() {
            return InstructionFlag.NONE;
        }

        @Override
        public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
            return visitor.visitTryCatchHandler(this, ctx);
        }

        @Override
        protected void onChildModified() {
            super.onChildModified();
            if (this.isConnected()) {
                this.getVariable().setWrittenTo(true);
            }
        }

        @Override
        protected void onConnected() {
            super.onConnected();
            this.getVariable().setWrittenTo(true);
        }

        public LocalReference getVariable() {
            return this.variable.get();
        }

        public BlockContainer getBody() {
            return this.body.get();
        }

        public void setVariable(Store variable) {
            this.variable.set(variable);
        }

        public TryCatch getTry() {
            return (TryCatch)this.getParent();
        }
    }
}

