/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.AbstractLoop;
import net.covers1624.coffeegrinder.bytecode.insns.ArrayElementReference;
import net.covers1624.coffeegrinder.bytecode.insns.BinaryOp;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.Comparison;
import net.covers1624.coffeegrinder.bytecode.insns.Continue;
import net.covers1624.coffeegrinder.bytecode.insns.DoWhileLoop;
import net.covers1624.coffeegrinder.bytecode.insns.ForEachLoop;
import net.covers1624.coffeegrinder.bytecode.insns.ForLoop;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.LogicNot;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.WhileLoop;
import net.covers1624.coffeegrinder.bytecode.matching.AssignmentMatching;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.matching.ComparisonMatching;
import net.covers1624.coffeegrinder.bytecode.matching.IfMatching;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LdcMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.ConditionDetection;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.ExpressionTransforms;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.Inlining;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.util.None;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class HighLevelLoops
extends SimpleInsnVisitor<MethodTransformContext>
implements MethodTransformer {
    private static final Type ITERATOR = Type.getType(Iterator.class);
    private static final Type ITERABLE = Type.getType(Iterable.class);
    private final ClassType iteratorClass;
    private final ClassType iterableClass;

    public HighLevelLoops(TypeResolver typeResolver) {
        this.iteratorClass = typeResolver.resolveClass(ITERATOR);
        this.iterableClass = typeResolver.resolveClass(ITERABLE);
    }

    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        function.accept(this, ctx);
    }

    @Override
    public None visitWhileLoop(WhileLoop basicLoop, MethodTransformContext ctx) {
        super.visitWhileLoop(basicLoop, ctx);
        ctx.pushStep("Replace branches with continues");
        basicLoop.getBody().getEntryPoint().getBranches().toList().forEach(e -> e.replaceWith(new Continue(basicLoop).withOffsets((Instruction)e)));
        ctx.popStep();
        if (HighLevelLoops.transformWhileLoop(basicLoop, ctx)) {
            if (!HighLevelLoops.transformForLoop(basicLoop, ctx)) {
                this.transformIteratorForEachLoop(basicLoop, ctx);
            }
        } else if (!HighLevelLoops.transformDoWhileLoop(basicLoop, ctx)) {
            HighLevelLoops.transformForLoop(basicLoop, ctx);
        }
        return NONE;
    }

    private static boolean transformWhileLoop(WhileLoop loop, MethodTransformContext ctx) {
        BlockContainer body = loop.getBody();
        Block entryPoint = body.getEntryPoint();
        if (entryPoint.getFirstChild().opcode != InsnOpcode.IF) {
            return false;
        }
        IfInstruction ifInsn = (IfInstruction)entryPoint.getFirstChild();
        if (ifInsn.getFalseInsn().opcode != InsnOpcode.NOP) {
            return false;
        }
        if (entryPoint.instructions.size() != 2 || BranchLeaveMatching.matchLeave((Instruction)entryPoint.instructions.last(), body) == null) {
            return false;
        }
        if (!ifInsn.getTrueInsn().hasFlag(InstructionFlag.END_POINT_UNREACHABLE)) {
            ((Block)ifInsn.getTrueInsn()).instructions.add(new Leave(body));
        }
        ConditionDetection.invertIf(ifInsn, ctx);
        ctx.pushStep("Capture While condition");
        loop.setCondition(new LogicNot(ifInsn.getCondition()));
        ifInsn.remove();
        ExpressionTransforms.runOnExpression(loop.getCondition(), ctx);
        ctx.popStep();
        return true;
    }

    private static boolean transformForLoop(WhileLoop whileLoop, MethodTransformContext ctx) {
        Block incBlock;
        if (whileLoop.getContinues().count() > 1) {
            return false;
        }
        BlockContainer body = whileLoop.getBody();
        Block lastBlock = (Block)body.getLastChild();
        if (Continue.matchContinue(lastBlock.getLastChild(), whileLoop) == null) {
            return false;
        }
        Store store = LoadStoreMatching.matchStoreLocal(whileLoop.getPrevSiblingOrNull());
        BlockContainer loopBodyEnd = HighLevelLoops.findLabelledContainerFromEndOfBlock(lastBlock);
        if (loopBodyEnd != null) {
            if (loopBodyEnd.getNextSibling() == lastBlock.getLastChild()) {
                return false;
            }
            incBlock = lastBlock.extractRange("increment", loopBodyEnd.getNextSibling(), Objects.requireNonNull(lastBlock.instructions.secondToLastOrDefault()));
        } else {
            if (store == null || body.blocks.size() > 1) {
                return false;
            }
            Instruction increment = lastBlock.instructions.secondToLastOrDefault();
            if (increment == null || !HighLevelLoops.isSimpleStatement(increment)) {
                return false;
            }
            if (increment.descendantsMatching(e -> LoadStoreMatching.matchLocalRef(e, store.getVariable())).isEmpty()) {
                return false;
            }
            incBlock = lastBlock.extractRange("increment", increment, increment);
        }
        ctx.pushStep("Produce for loop");
        Instruction initializer = store != null ? store : new Nop();
        ForLoop forLoop = HighLevelLoops.replaceLoop(whileLoop, new ForLoop(initializer, whileLoop.getCondition(), body, incBlock));
        HighLevelLoops.transformArrayForEachLoop(forLoop, ctx);
        ctx.popStep();
        return true;
    }

    private boolean transformIteratorForEachLoop(WhileLoop whileLoop, MethodTransformContext ctx) {
        Invoke nextInvoke;
        Invoke hasNextInvoke = InvokeMatching.matchInvoke(whileLoop.getCondition(), Invoke.InvokeKind.INTERFACE, "hasNext", Type.getMethodType((String)"()Z"));
        if (hasNextInvoke == null) {
            return false;
        }
        Load condLoad = LoadStoreMatching.matchLoadLocal(hasNextInvoke.getTarget());
        if (condLoad == null) {
            return false;
        }
        LocalVariable iteratorVar = condLoad.getVariable();
        if (!iteratorVar.isSynthetic() || iteratorVar.getLoadCount() != 2 || iteratorVar.getStoreCount() != 1) {
            return false;
        }
        if (!TypeSystem.isAssignableTo(iteratorVar.getType(), (AType)this.iteratorClass)) {
            return false;
        }
        Store iteratorStore = LoadStoreMatching.matchStoreLocal(whileLoop.getPrevSiblingOrNull(), iteratorVar);
        if (iteratorStore == null) {
            return false;
        }
        Invoke iteratorInvoke = InvokeMatching.matchInvoke(iteratorStore.getValue());
        if (iteratorInvoke == null || iteratorInvoke.getKind() != Invoke.InvokeKind.VIRTUAL && iteratorInvoke.getKind() != Invoke.InvokeKind.INTERFACE) {
            return false;
        }
        Method iteratorInvokeMethod = iteratorInvoke.getMethod();
        if (!iteratorInvokeMethod.getName().equals("iterator")) {
            return false;
        }
        if (!iteratorInvokeMethod.getParameters().isEmpty()) {
            return false;
        }
        if (!TypeSystem.isAssignableTo(iteratorInvokeMethod.getReturnType(), (AType)this.iteratorClass)) {
            return false;
        }
        if (!TypeSystem.isAssignableTo(iteratorInvoke.getTarget().getResultType(), (AType)this.iterableClass)) {
            return false;
        }
        Store nextStore = LoadStoreMatching.matchStoreLocal(whileLoop.getBody().getEntryPoint().getFirstChildOrNull());
        if (nextStore == null) {
            return false;
        }
        Instruction nextStoreValue = nextStore.getValue();
        if (nextStoreValue.opcode == InsnOpcode.CHECK_CAST) {
            nextStoreValue = ((Cast)nextStoreValue).getArgument();
        }
        if ((nextInvoke = InvokeMatching.matchInvoke(nextStoreValue, Invoke.InvokeKind.INTERFACE, "next")) == null || LoadStoreMatching.matchLoadLocal(nextInvoke.getTarget(), iteratorVar) == null) {
            return false;
        }
        ctx.pushStep("Produce foreach loop from Iterator");
        HighLevelLoops.replaceLoop(whileLoop, new ForEachLoop((LocalReference)nextStore.getReference(), iteratorInvoke.getTarget(), whileLoop.getBody()));
        iteratorStore.remove();
        nextStore.remove();
        ctx.popStep();
        return false;
    }

    private static boolean transformArrayForEachLoop(ForLoop forLoop, MethodTransformContext ctx) {
        Store synIndexStore = LoadStoreMatching.matchStoreLocal(forLoop.getInitializer());
        if (synIndexStore == null || LdcMatching.matchLdcInt(synIndexStore.getValue(), 0) == null) {
            return false;
        }
        LocalVariable synIndex = synIndexStore.getVariable();
        if (!synIndex.isSynthetic() || synIndex.getLoadCount() != 3 || synIndex.getStoreCount() != 2) {
            return false;
        }
        Store synLenStore = LoadStoreMatching.matchStoreLocal(forLoop.getPrevSiblingOrNull());
        if (synLenStore == null) {
            return false;
        }
        LocalVariable synLen = synLenStore.getVariable();
        if (!synLen.isSynthetic() || synLen.getLoadCount() != 1 || synLen.getStoreCount() != 1) {
            return false;
        }
        Store synArrayStore = LoadStoreMatching.matchStoreLocal(synLenStore.getPrevSiblingOrNull());
        if (synArrayStore == null) {
            return false;
        }
        LocalVariable synArray = synArrayStore.getVariable();
        if (!synArray.isSynthetic() || synArray.getLoadCount() != 2 || synArray.getStoreCount() != 1) {
            return false;
        }
        if (LoadStoreMatching.matchArrayLenLoad(synLenStore.getValue(), synArrayStore.getVariable()) == null) {
            return false;
        }
        if (ComparisonMatching.matchComparison(forLoop.getCondition(), Comparison.ComparisonKind.LESS_THAN, synIndex, synLen) == null) {
            return false;
        }
        if (AssignmentMatching.matchCompoundAssignment(forLoop.getIncrement().getFirstChild(), BinaryOp.ADD, 1) == null) {
            return false;
        }
        Store arrayStore = LoadStoreMatching.matchStoreLocal(forLoop.getBody().getEntryPoint().getFirstChildOrNull());
        if (arrayStore == null || !HighLevelLoops.isArrayElemLoad(arrayStore.getValue(), synArray, synIndex)) {
            return false;
        }
        ctx.pushStep("Produce foreach loop from array for-i");
        HighLevelLoops.replaceLoop(forLoop, new ForEachLoop((LocalReference)arrayStore.getReference(), synArrayStore.getValue(), forLoop.getBody()));
        synLenStore.remove();
        synArrayStore.remove();
        arrayStore.remove();
        ctx.popStep();
        return true;
    }

    private static boolean isArrayElemLoad(Instruction insn, LocalVariable arrayVar, LocalVariable indexVar) {
        ArrayElementReference elemRef = LoadStoreMatching.matchLoadElemRef(insn);
        if (elemRef == null) {
            return false;
        }
        Load array = LoadStoreMatching.matchLoadLocal(elemRef.getArray(), arrayVar);
        if (array == null) {
            return false;
        }
        Load index = LoadStoreMatching.matchLoadLocal(elemRef.getIndex(), indexVar);
        return index != null;
    }

    private static boolean transformDoWhileLoop(WhileLoop basicLoop, MethodTransformContext ctx) {
        if (basicLoop.getContinues().count() > 1) {
            return false;
        }
        BlockContainer body = basicLoop.getBody();
        Block lastBlock = (Block)body.getLastChild();
        if (Continue.matchContinue(lastBlock.getLastChild(), basicLoop) == null) {
            return false;
        }
        IfInstruction ifInsn = IfMatching.matchNopFalseIf(lastBlock.instructions.secondToLastOrDefault());
        if (ifInsn == null) {
            return false;
        }
        if (BranchLeaveMatching.matchLeave(ifInsn.getTrueInsn(), body) == null) {
            return false;
        }
        ctx.pushStep("Produce do-while loop");
        BlockContainer loopBodyEnd = HighLevelLoops.findLabelledContainerFromEndOfBlock(lastBlock);
        if (loopBodyEnd != null) {
            LinkedList<Runnable> extraTasks = new LinkedList<Runnable>();
            if (Inlining.matchWithPotentialInline(loopBodyEnd.getNextSibling(), extraTasks, ctx, e -> e == ifInsn ? ifInsn : null) != null) {
                extraTasks.forEach(Runnable::run);
            }
        }
        DoWhileLoop loop = HighLevelLoops.replaceLoop(basicLoop, new DoWhileLoop(body, new LogicNot(ifInsn.getCondition())));
        ifInsn.remove();
        ExpressionTransforms.runOnExpression(loop.getCondition(), ctx);
        ctx.popStep();
        return true;
    }

    @Nullable
    private static BlockContainer findLabelledContainerFromEndOfBlock(Block inBlock) {
        Instruction insn = inBlock.getLastChild();
        while (true) {
            if (insn == null) {
                return null;
            }
            if (insn.opcode == InsnOpcode.BLOCK_CONTAINER) break;
            insn = insn.getPrevSiblingOrNull();
        }
        return (BlockContainer)insn;
    }

    private static <T extends AbstractLoop> T replaceLoop(AbstractLoop oldLoop, T newLoop) {
        oldLoop.replaceWith(newLoop);
        for (Continue aContinue : oldLoop.getContinues().toList()) {
            aContinue.setLoop(newLoop);
        }
        assert (oldLoop.getContinues().isEmpty());
        return newLoop;
    }

    private static boolean isSimpleStatement(Instruction insn) {
        switch (insn.opcode) {
            case STORE: 
            case LOAD: 
            case POST_INCREMENT: 
            case COMPOUND_ASSIGNMENT: {
                return true;
            }
        }
        return false;
    }
}

