/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.util.resolver;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.covers1624.coffeegrinder.asm.ASMClassTransformer;
import net.covers1624.coffeegrinder.util.resolver.CachedClassNode;
import net.covers1624.coffeegrinder.util.resolver.Resolver;
import org.jetbrains.annotations.Nullable;

public class ClassResolver {
    private final Map<String, CachedClassNode> classNodeCache = new ConcurrentHashMap<String, CachedClassNode>();
    private final Object2BooleanMap<String> availabilityCache = Object2BooleanMaps.synchronize((Object2BooleanMap)new Object2BooleanOpenHashMap());
    private final List<ASMClassTransformer> transformers = ImmutableList.of();
    @Nullable
    private Resolver targetResolver = null;
    private final List<Resolver> resolvers = new ArrayList<Resolver>();

    public void setTarget(Path target) {
        if (this.targetResolver != null) {
            throw new IllegalStateException("Target already set, merge your jars.");
        }
        this.setTarget(Resolver.findResolver(target));
    }

    public void setTarget(Resolver resolver) {
        this.targetResolver = resolver;
    }

    public void addResolverFirst(Path path) {
        this.resolvers.add(0, Resolver.findResolver(path));
    }

    public void addResolver(Path path) {
        this.resolvers.add(Resolver.findResolver(path));
    }

    public void addResolvers(Iterable<Path> paths) {
        for (Path path : paths) {
            this.addResolver(path);
        }
    }

    public Resolver getTargetResolver() {
        if (this.targetResolver == null) {
            throw new IllegalStateException("No target set.");
        }
        return this.targetResolver;
    }

    public boolean classExists(String cName) {
        return this.availabilityCache.computeIfAbsent((Object)cName, e -> {
            if (this.targetResolver != null && this.targetResolver.hasClass(cName)) {
                return true;
            }
            for (Resolver resolver : this.resolvers) {
                if (!resolver.hasClass(cName)) continue;
                return true;
            }
            return false;
        });
    }

    public byte @Nullable [] getBytes(String cName) throws IOException {
        if (!this.availabilityCache.getOrDefault((Object)(cName = cName.replace(".", "/")), true)) {
            return null;
        }
        byte[] bytes = null;
        if (this.targetResolver != null) {
            bytes = this.targetResolver.getClassBytes(cName);
        }
        if (bytes == null) {
            Resolver resolver;
            Iterator<Resolver> iterator = this.resolvers.iterator();
            while (iterator.hasNext() && (bytes = (resolver = iterator.next()).getClassBytes(cName)) == null) {
            }
        }
        this.availabilityCache.put((Object)cName, bytes != null);
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedClassNode getClassNode(String cName) {
        if (!this.availabilityCache.getOrDefault((Object)cName, true)) {
            throw new ClassNotFoundException(cName);
        }
        String string = cName.intern();
        synchronized (string) {
            CachedClassNode node = this.classNodeCache.get(cName);
            if (node == null) {
                try {
                    byte[] bytes = this.getBytes(cName);
                    if (bytes == null) {
                        throw new ClassNotFoundException(cName);
                    }
                    node = new CachedClassNode(bytes, this.transformers);
                    this.classNodeCache.put(cName, node);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to construct CachedClassNode.", e);
                }
            }
            return node;
        }
    }

    public void reset() {
        this.availabilityCache.clear();
        this.classNodeCache.clear();
    }

    @Deprecated
    public static class ClassNotFoundException
    extends RuntimeException {
        public ClassNotFoundException(String cName) {
            super(cName);
        }
    }
}

