/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.jetbrains.annotations.Nullable;

public class Assert
extends Instruction {
    private final InstructionSlot<Instruction> condition = new InstructionSlot(this);
    private final InstructionSlot<Instruction> message = new InstructionSlot(this);

    public Assert(Instruction condition, @Nullable Instruction message) {
        super(InsnOpcode.ASSERT);
        this.condition.set(condition);
        this.message.set(message != null ? message : new Nop());
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.MAY_THROW.toSet();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitAssert(this, ctx);
    }

    public Instruction getCondition() {
        return this.condition.get();
    }

    public Instruction getMessage() {
        return this.message.get();
    }
}

