/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type.asm;

import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.AnnotationSupplier;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.RawField;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.asm.AsmClass;
import net.covers1624.coffeegrinder.type.asm.ReferenceTypeSignatureParser;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import net.covers1624.coffeegrinder.util.Util;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.FieldNode;

public class AsmField
extends Field {
    private final TypeResolver typeResolver;
    private final AsmClass owner;
    private final FieldNode fNode;
    private final Type desc;
    private final AType type;
    @Nullable
    private final AType genericType;
    private final EnumBitSet<AccessFlag> accessFlags;
    private final AnnotationSupplier annotationSupplier;

    AsmField(TypeResolver typeResolver, AsmClass owner, FieldNode fNode) {
        this.typeResolver = typeResolver;
        this.owner = owner;
        this.fNode = fNode;
        this.desc = Type.getType((String)fNode.desc);
        this.type = typeResolver.resolveType(this.desc);
        this.genericType = fNode.signature != null ? ReferenceTypeSignatureParser.parse(typeResolver, owner, fNode.signature) : null;
        this.accessFlags = AccessFlag.unpackField(fNode.access);
        this.annotationSupplier = new AnnotationSupplier(typeResolver, Util.safeConcat(fNode.visibleAnnotations, fNode.invisibleAnnotations), Util.safeConcat(fNode.visibleTypeAnnotations, fNode.invisibleTypeAnnotations));
    }

    public FieldNode getNode() {
        return this.fNode;
    }

    @Override
    public ClassType getDeclaringClass() {
        return this.owner;
    }

    @Override
    public EnumBitSet<AccessFlag> getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    public String getName() {
        return this.fNode.name;
    }

    @Override
    public AType getType() {
        return this.genericType != null ? this.genericType : this.type;
    }

    @Override
    public Type getDescriptor() {
        return this.desc;
    }

    @Override
    public AnnotationSupplier getAnnotationSupplier() {
        return this.annotationSupplier;
    }

    @Override
    @Nullable
    public Object getConstantValue() {
        return this.fNode.value;
    }

    @Override
    public Field getDeclaration() {
        return this;
    }

    @Override
    public Field asRaw() {
        return this.genericType != null ? new RawField(this, this.type) : this;
    }
}

