/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type.asm;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.ITypeParameterizedMember;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.asm.ReferenceTypeSignatureParser;
import net.covers1624.coffeegrinder.type.asm.SignatureParser;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class ClassSignatureParser
extends SignatureParser {
    @Nullable
    private ClassType superClass;
    private final ImmutableList.Builder<ClassType> interfaces = ImmutableList.builder();

    private ClassSignatureParser(TypeResolver typeResolver, ITypeParameterizedMember scope) {
        super(typeResolver, scope);
    }

    public static ClassSignatureParser parse(TypeResolver typeResolver, ITypeParameterizedMember scope, String signature) {
        ClassSignatureParser visitor = new ClassSignatureParser(typeResolver, scope);
        new SignatureReader(signature).accept((SignatureVisitor)visitor);
        return visitor;
    }

    public ClassType getSuperClass() {
        return Objects.requireNonNull(this.superClass);
    }

    public List<ClassType> getInterfaces() {
        return this.interfaces.build();
    }

    public SignatureVisitor visitSuperclass() {
        return new ReferenceTypeSignatureParser(this.typeResolver, this.scope){

            @Override
            public void endType(AType type) {
                ClassSignatureParser.this.superClass = (ClassType)type;
            }
        };
    }

    public SignatureVisitor visitInterface() {
        return new ReferenceTypeSignatureParser(this.typeResolver, this.scope){

            @Override
            public void endType(AType type) {
                ClassSignatureParser.this.interfaces.add((Object)((ClassType)type));
            }
        };
    }
}

