/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.HashSet;
import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.bytecode.insns.Yield;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class SwitchExpressions
implements StatementTransformer {
    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        Switch sSwitch = SwitchExpressions.matchSwitch(statement);
        if (sSwitch == null) {
            return;
        }
        BlockContainer switchBody = sSwitch.getBody();
        HashSet<LocalVariable> candidateVars = new HashSet<LocalVariable>();
        for (Leave leave : switchBody.getLeaves()) {
            Store store = LoadStoreMatching.matchStore(leave.getPrevSiblingOrNull());
            if (store == null) {
                return;
            }
            LocalReference r = LoadStoreMatching.matchLocalRef(store.getReference());
            if (r == null) {
                return;
            }
            if (r.variable.getKind() != LocalVariable.VariableKind.STACK_SLOT) {
                return;
            }
            candidateVars.add(r.variable);
        }
        LocalVariable stackVar = (LocalVariable)FastStream.of(candidateVars).onlyOrDefault();
        if (stackVar == null) {
            return;
        }
        if (stackVar.getLoadCount() != 1) {
            return;
        }
        ctx.pushStep("Produce switch expression.");
        Switch newSwitch = new Switch(sSwitch.getValue(), switchBody, stackVar.getType());
        for (Leave leave : switchBody.getLeaves().toList()) {
            Store store = (Store)leave.getPrevSibling();
            leave.replaceWith(new Yield(newSwitch, store.getValue()).withOffsets(leave));
            store.remove();
        }
        sSwitch.replaceWith(new Store(new LocalReference(stackVar), newSwitch));
        ctx.popStep();
    }

    @Contract(value="null->null")
    @Nullable
    public static Switch matchSwitch(@Nullable Instruction insn) {
        if (insn == null || insn.opcode != InsnOpcode.SWITCH) {
            return null;
        }
        return (Switch)insn;
    }
}

