/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.AnnotationSupplier;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.Parameter;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeParameter;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class PolymorphicSignatureMethod
extends Method {
    private final Method decl;
    private final Type desc;
    private final AType returnType;
    private final List<Parameter> parameters;

    public PolymorphicSignatureMethod(Method decl, TypeResolver typeResolver, Type desc) {
        this.decl = decl;
        this.desc = desc;
        this.returnType = typeResolver.resolveType(TypeResolver.OBJECT_TYPE);
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = 0;
        for (Type arg : desc.getArgumentTypes()) {
            builder.add((Object)new Parameter("p_" + i++, this, typeResolver.resolveType(arg), EnumBitSet.noneOf(AccessFlag.class)));
        }
        this.parameters = builder.build();
    }

    @Override
    public List<TypeParameter> getTypeParameters() {
        return ImmutableList.of();
    }

    @Override
    public ClassType getDeclaringClass() {
        return this.decl.getDeclaringClass();
    }

    @Override
    public String getName() {
        return this.decl.getName();
    }

    @Override
    public AType getReturnType() {
        return this.returnType;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public List<ReferenceType> getExceptions() {
        return this.decl.getExceptions();
    }

    @Override
    public EnumBitSet<AccessFlag> getAccessFlags() {
        return this.decl.getAccessFlags();
    }

    @Override
    public Type getDescriptor() {
        return this.desc;
    }

    @Override
    public AnnotationSupplier getAnnotationSupplier() {
        return this.decl.getAnnotationSupplier();
    }

    @Override
    @Nullable
    public Object getDefaultAnnotationValue() {
        return null;
    }

    @Override
    public Method getDeclaration() {
        return this;
    }

    @Override
    public Method asRaw() {
        return this;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }
}

