/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Set;
import org.objectweb.asm.Opcodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcodeLookup {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpcodeLookup.class);
    private static final Object2IntMap<String> OPCODES = new Object2IntOpenHashMap();
    private static final Int2ObjectMap<String> OPCODES_LOOKUP = new Int2ObjectArrayMap();

    public static int lookupOpcode(String name) {
        return OPCODES.getInt((Object)name);
    }

    public static String getName(int opcode) {
        return (String)OPCODES_LOOKUP.get(opcode);
    }

    public static Set<String> getOpcodeNames() {
        return Collections.unmodifiableSet(OPCODES.keySet());
    }

    static {
        OPCODES.defaultReturnValue(-1);
        boolean foundNop = false;
        for (Field field : Opcodes.class.getDeclaredFields()) {
            String name = field.getName();
            if (name.equals("NOP")) {
                foundNop = true;
            }
            if (!foundNop || field.isSynthetic()) continue;
            try {
                int i = field.getInt(null);
                OPCODES.put((Object)name, i);
                OPCODES_LOOKUP.put(i, (Object)name);
            }
            catch (IllegalAccessException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}

