package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ArrayType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 7/12/21.
 */
public class ArrayElementReference extends Reference {

    private final InstructionSlot<Instruction> array = new InstructionSlot<>(this);
    private final InstructionSlot<Instruction> index = new InstructionSlot<>(this);

    public ArrayElementReference(Instruction array, Instruction index) {
        super(InsnOpcode.ARRAY_ELEMENT_REFERENCE);
        this.array.set(array);
        this.index.set(index);
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.MAY_THROW.toSet();
    }

    @Override
    public AType getType() {
        return ((ArrayType) array.get().getResultType()).getElementType();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitArrayElementReference(this, ctx);
    }

    public Instruction getArray() {
        return array.get();
    }

    public Instruction getIndex() {
        return index.get();
    }
}
