package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 13/4/21.
 */
public class Cast extends Unary {

    private AType type;

    public Cast(Instruction argument, AType type) {
        super(InsnOpcode.CHECK_CAST, argument);
        this.type = type;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return type instanceof PrimitiveType ? InstructionFlag.NONE : InstructionFlag.MAY_THROW.toSet();
    }

    @Override
    public AType getResultType() {
        return type;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitCheckCast(this, ctx);
    }

    @Override
    public Instruction copy() {
        return new Cast(getArgument().copy(), type);
    }

    public AType getType() {
        return type;
    }

    public void setType(AType type) {
        this.type = type;
        invalidateFlags();
    }
}
