package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 5/4/21.
 */
public class Throw extends Unary {

    private static final EnumBitSet<InstructionFlag> FLAGS = EnumBitSet.of(InstructionFlag.MAY_THROW, InstructionFlag.END_POINT_UNREACHABLE);

    public Throw(Instruction argument) {
        super(InsnOpcode.THROW, argument);
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return FLAGS;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitThrow(this, ctx);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }
}
