package net.covers1624.coffeegrinder.type;

import com.google.common.collect.ImmutableList;
import net.covers1624.quack.collection.FastStream;

import java.util.List;

import static net.covers1624.coffeegrinder.type.TypeResolver.*;

/**
 * Created by covers1624 on 12/4/21.
 */
public class ArrayType extends ReferenceType {

    private final TypeResolver typeResolver;
    private final AType elementType;
    private final ClassType superClass;
    private final List<ClassType> directSuperTypes;

    protected ArrayType(TypeResolver typeResolver, AType elementType) {
        this.typeResolver = typeResolver;
        this.elementType = elementType;
        superClass = typeResolver.resolveClass(OBJECT_TYPE);
        directSuperTypes = ImmutableList.of(
                superClass,
                typeResolver.resolveClass(CLONEABLE_TYPE),
                typeResolver.resolveClass(SERIALIZABLE_TYPE)
        );
    }

    protected ArrayType(TypeResolver typeResolver, AType elementType, ClassType superClass, List<ClassType> directSuperTypes) {
        this.typeResolver = typeResolver;
        this.elementType = elementType;
        this.superClass = superClass;
        this.directSuperTypes = directSuperTypes;
    }

    public ArrayType withElementType(AType elementType) {
        if (elementType == this.elementType) return this;
        return new ArrayType(typeResolver, elementType, superClass, directSuperTypes);
    }

    public AType getElementType() {
        return elementType;
    }

    @Override
    public ReferenceType getSuperType() {
        return superClass;
    }

    @Override
    public FastStream<ClassType> getDirectSuperTypes() {
        return FastStream.of(directSuperTypes);
    }

    @Override
    public String getName() {
        return elementType.getName() + "[]";
    }

    @Override
    public String getFullName() {
        return elementType.getFullName() + "[]";
    }

    @Override
    public String toString() {
        return getFullName();
    }

    @Override
    public boolean mentions(ReferenceType type) {
        return super.mentions(type) ||
                elementType instanceof ReferenceType && elementType.mentions(type);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ArrayType)) return false;
        ArrayType other = (ArrayType) o;

        return getElementType().equals(other.getElementType());
    }

    @Override
    public int hashCode() {
        return elementType.hashCode();
    }
}
