/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.testengine.testcase.target;

import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.covers1624.coffeegrinder.DecompilerSettings;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.testengine.testcase.TestCase;
import net.covers1624.coffeegrinder.testengine.testcase.TestCaseEngineDescriptor;
import net.covers1624.coffeegrinder.testengine.testcase.target.TargetStepDescriptor;
import net.covers1624.coffeegrinder.testengine.testcase.util.OutputPath;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.util.resolver.ClassResolver;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.hierarchical.OpenTest4JAwareThrowableCollector;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.IncompleteExecutionException;
import org.opentest4j.MultipleFailuresError;
import org.opentest4j.TestAbortedException;

public class TestCaseDescriptor
extends AbstractTestDescriptor {
    public final TestCase testCase;
    public final TestCaseEngineDescriptor root;
    public final boolean outputMandatory;
    public final OutputPath.Entry outputAst;
    public final OutputPath.Entry outputSource;
    @Nullable
    public final OutputPath.Entry outputCompileError;
    @Nullable
    public final OutputPath.Entry outputRTDiff;
    public final Map<String, byte[]> compileOutput = new HashMap<String, byte[]>();
    public final Path inputRoot;
    public final Path inputClass;
    public final Set<Path> innerClassPaths;
    public final ClassResolver classResolver;
    public final DecompilerSettings settings = new DecompilerSettings();
    @Nullable
    private TypeResolver typeResolver;
    @Nullable
    public ClassDecl classInsn;
    @Nullable
    public String source;

    public TestCaseDescriptor(UniqueId parentId, TestCase testCase, TestCaseEngineDescriptor root) {
        super(parentId.append("class", testCase.className), testCase.className, (TestSource)ClassSource.from((String)testCase.className));
        this.testCase = testCase;
        this.root = root;
        this.outputMandatory = testCase.className.startsWith(root.mandatoryOutputPackage);
        this.outputAst = root.outputAstPath.pathFor(testCase);
        this.outputSource = root.outputSourcePath.pathFor(testCase);
        this.outputCompileError = OutputPath.optionalPathFor(root.outputCompileErrorPath, testCase);
        this.outputRTDiff = OutputPath.optionalPathFor(root.outputRoundTripDiffsPath, testCase);
        this.inputRoot = root.inputClassPaths.getRoot();
        this.inputClass = root.inputClassPaths.getPathFor(testCase);
        this.innerClassPaths = ImmutableSet.copyOf(root.inputClassPaths.findInners(testCase));
        this.classResolver = root.classResolver;
        this.typeResolver = new TypeResolver(this.classResolver);
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public TypeResolver typeResolver() {
        return Objects.requireNonNull(this.typeResolver);
    }

    public void execute(EngineExecutionListener listener) {
        boolean[] isFailed = new boolean[]{false};
        listener.executionStarted((TestDescriptor)this);
        for (TestDescriptor child : this.getChildren()) {
            if (isFailed[0]) {
                listener.executionSkipped(child, "Previous steps failed.");
                continue;
            }
            OpenTest4JAwareThrowableCollector collector = new OpenTest4JAwareThrowableCollector();
            listener.executionStarted(child);
            collector.execute(() -> {
                isFailed[0] = this.executeTarget((TargetStepDescriptor)child);
            });
            listener.executionFinished(child, collector.toTestExecutionResult());
            isFailed[0] = isFailed[0] | collector.isNotEmpty();
        }
        if (!this.root.updateLibraryDefs && this.testCase.brokenData != null && this.testCase.processingError == null) {
            listener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)new AssertionFailedError("Test processing passed without crashes. Remove Broken")));
        } else {
            listener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        }
        this.compileOutput.clear();
        this.typeResolver = null;
        this.classInsn = null;
        this.source = null;
    }

    private boolean executeTarget(TargetStepDescriptor step) throws Throwable {
        boolean isRequested = step.target.ordinal() <= this.testCase.target.ordinal();
        try {
            step.execute(this);
            this.testCase.reachedTarget = step.target;
        }
        catch (Throwable ex) {
            boolean isTestAssertion = TestCaseDescriptor.isTestAssertion(ex);
            if (!isTestAssertion) {
                this.testCase.processingError = new TestCase.BrokenData(ex.getClass(), false, ex.getMessage(), ExceptionUtils.getStackTrace((Throwable)ex));
            }
            if (this.root.updateLibraryDefs) {
                return false;
            }
            if (!isRequested) {
                throw new TestAbortedException("Failure expected.", ex);
            }
            if (isTestAssertion || this.testCase.brokenData == null) {
                throw ex;
            }
            if (ex.getClass() != this.testCase.brokenData.expected) {
                Assertions.fail((String)("Expected failure of: " + this.testCase.brokenData.expected), (Throwable)ex);
            }
            if (!this.testCase.brokenData.ignoreExceptionMessages) {
                Assertions.assertEquals((Object)this.testCase.brokenData.message, (Object)ex.getMessage(), (String)"Exception message differs from expected.");
            }
            return true;
        }
        if (this.root.updateLibraryDefs) {
            return false;
        }
        if (!isRequested) {
            Assertions.fail((String)("Testcase passed " + step.target + " but we only expected " + this.testCase.target));
        }
        return false;
    }

    private static boolean isTestAssertion(Throwable ex) {
        if (ex instanceof AssertionFailedError) {
            return true;
        }
        if (ex instanceof MultipleFailuresError) {
            return true;
        }
        return ex instanceof IncompleteExecutionException;
    }
}

