/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.util.resolver;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.covers1624.coffeegrinder.asm.ASMClassTransformer;
import net.covers1624.coffeegrinder.util.asm.CustomInsnList;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class CachedClassNode {
    private ClassReader reader;
    private final List<ASMClassTransformer> transformers;
    @Nullable
    private ClassNode partialNode;
    @Nullable
    private ClassNode node;
    private final int access;
    private final String name;
    private final String superName;
    private final List<String> interfaces;
    @Nullable
    private Map<String, FieldNode> fieldNodes;
    @Nullable
    private Map<String, MethodNode> methodNodes;

    CachedClassNode(byte[] bytes, List<ASMClassTransformer> transformers) {
        this.reader = new ClassReader(bytes);
        this.transformers = transformers;
        this.access = this.reader.getAccess();
        this.name = this.reader.getClassName();
        this.superName = this.reader.getSuperName();
        this.interfaces = ImmutableList.copyOf((Object[])this.reader.getInterfaces());
        assert (this.superName != null || this.name.equals("java/lang/Object"));
    }

    public int getAccess() {
        return this.access;
    }

    public String getClassName() {
        return this.name;
    }

    @Nullable
    public String getSuperName() {
        return this.superName;
    }

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public ClassNode getPartialNode() {
        this.requirePartial();
        return this.node != null ? this.node : this.partialNode;
    }

    public ClassNode getNode() {
        this.requireFull();
        return this.node;
    }

    public FieldNode findField(String name, String desc) {
        this.requirePartial();
        assert (this.fieldNodes != null);
        return this.fieldNodes.get(name + desc);
    }

    public MethodNode findMethod(String name, String desc) {
        this.requirePartial();
        assert (this.methodNodes != null);
        return this.methodNodes.get(name + desc);
    }

    public MethodNode findFullMethod(String name, String desc) {
        this.requireFull();
        assert (this.methodNodes != null);
        return this.methodNodes.get(name + desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requirePartial() {
        if (this.partialNode != null || this.node != null) {
            return;
        }
        CachedClassNode cachedClassNode = this;
        synchronized (cachedClassNode) {
            if (this.partialNode != null || this.node != null) {
                return;
            }
            ClassNode partialNode = new ClassNode();
            this.reader.accept((ClassVisitor)partialNode, 1);
            for (ASMClassTransformer transformer : this.transformers) {
                transformer.transform(partialNode);
            }
            this.processFields(partialNode);
            this.processMethods(partialNode);
            this.partialNode = partialNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requireFull() {
        if (this.node != null) {
            return;
        }
        CachedClassNode cachedClassNode = this;
        synchronized (cachedClassNode) {
            if (this.node != null) {
                return;
            }
            ClassNode node = new ClassNode();
            this.reader.accept((ClassVisitor)node, 8);
            for (MethodNode method : node.methods) {
                method.instructions = new CustomInsnList(method.instructions);
            }
            for (ASMClassTransformer transformer : this.transformers) {
                transformer.transform(node);
            }
            this.processFields(node);
            this.processMethods(node);
            this.node = node;
            this.reader = null;
            this.partialNode = null;
        }
    }

    private void processFields(ClassNode node) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (FieldNode field : node.fields) {
            builder.put((Object)(field.name + field.desc), (Object)field);
        }
        this.fieldNodes = builder.build();
    }

    private void processMethods(ClassNode node) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (MethodNode method : node.methods) {
            builder.put((Object)(method.name + method.desc), (Object)method);
        }
        this.methodNodes = builder.build();
    }
}

