/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.IOFunction;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class EngineResult {
    @Nullable
    private final File file;
    @Nullable
    private final String string;

    private EngineResult(@Nullable File file, @Nullable String string) {
        this.file = file;
        this.string = string;
    }

    public static EngineResult fromFile(File file) {
        return new EngineResult(file, null);
    }

    public static EngineResult fromString(String string) {
        return new EngineResult(null, string);
    }

    public EngineResult mapString(Function<String, String> mapper) {
        return this.string == null ? this : EngineResult.fromString(mapper.apply(this.string));
    }

    public void consume(Consumer<File> fileConsumer, Consumer<String> stringConsumer) {
        if (this.string == null) {
            fileConsumer.accept(this.file);
        } else {
            stringConsumer.accept(this.string);
        }
        this.close();
    }

    public <T> T map(Function<File, T> fileMapper, Function<String, T> stringMapper) {
        T res = this.string == null ? fileMapper.apply(this.file) : stringMapper.apply(this.string);
        this.close();
        return res;
    }

    public String asString() throws IOException {
        return this.mapIO(EngineResult::readFile, string -> string);
    }

    <T> T mapIO(IOFunction<File, T> fileMapper, IOFunction<String, T> stringMapper) throws IOException {
        T res = this.string == null ? fileMapper.apply(this.file) : stringMapper.apply(this.string);
        this.close();
        return res;
    }

    private void close() {
        if (this.file != null) {
            this.file.delete();
        }
    }

    private static String readFile(File file) throws IOException {
        StringBuilder s = new StringBuilder();
        try (Stream<String> stream = Files.lines(file.toPath(), StandardCharsets.UTF_8);){
            stream.forEach(line -> s.append((String)line).append("\n"));
        }
        return s.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EngineResult that = (EngineResult)o;
        return Objects.equals(this.file, that.file) && Objects.equals(this.string, that.string);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.string);
    }

    public String toString() {
        return "EngineResult{file=" + this.file + ", string='" + this.string + '\'' + '}';
    }
}

