/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import java.util.Arrays;
import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionCollection;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.type.ArrayType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public class NewArray
extends Instruction {
    private ArrayType type;
    public final boolean isInitializer;
    private final InstructionCollection<Instruction> children = new InstructionCollection(this);

    public NewArray(ArrayType type, boolean isInitializer, Iterable<Instruction> children) {
        super(InsnOpcode.NEW_ARRAY);
        this.type = type;
        this.isInitializer = isInitializer;
        this.children.addAll(children);
    }

    public NewArray(ArrayType type, boolean isInitializer, Instruction ... children) {
        this(type, isInitializer, Arrays.asList(children));
    }

    @Override
    public ArrayType getResultType() {
        return this.type;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.MAY_THROW.toSet();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitNewArray(this, ctx);
    }

    public ArrayType getType() {
        return this.type;
    }

    public void setType(ArrayType type) {
        this.type = type;
    }

    public InstructionCollection<Instruction> getIndices() {
        if (this.isInitializer) {
            throw new IllegalStateException("Does not have indicies.");
        }
        return this.children;
    }

    public InstructionCollection<Instruction> getValues() {
        if (!this.isInitializer) {
            throw new IllegalStateException("Does not have values.");
        }
        return this.children;
    }
}

