package net.covers1624.coffeegrinder.asm.transformers;

import com.google.common.collect.ImmutableList;
import net.covers1624.coffeegrinder.asm.ASMClassTransformer;
import net.covers1624.coffeegrinder.asm.ASMMethodTransformer;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

import java.util.Arrays;
import java.util.List;

/**
 * Created by covers1624 on 8/6/21.
 */
public class ClassMethodTransformer implements ASMClassTransformer {

    private final List<ASMMethodTransformer> transformers;

    public ClassMethodTransformer(List<ASMMethodTransformer> transformers) {
        this.transformers = ImmutableList.copyOf(transformers);
    }

    public static ClassMethodTransformer of(ASMMethodTransformer... transformers) {
        return new ClassMethodTransformer(Arrays.asList(transformers));
    }

    @Override
    public void transform(ClassNode cNode) {
        for (MethodNode mNode : cNode.methods) {
            for (ASMMethodTransformer transformer : transformers) {
                transformer.transform(mNode, cNode);
            }
        }
    }
}
