package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;

/**
 * Created by covers1624 on 28/2/21.
 */
public class LdcString extends LdcInsn {

    private final ClassType stringType;
    private final String value;

    public LdcString(ClassType stringType, String value) {
        super(InsnOpcode.LDC_STRING);
        this.stringType = stringType;
        this.value = value;
    }

    @Override
    public AType getResultType() {
        return stringType;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitLdcString(this, ctx);
    }

    @Override
    public LdcString copy() {
        return new LdcString(stringType, value);
    }

    @Override
    public String getRawValue() {
        return value;
    }

    public String getValue() {
        return value;
    }
}
