package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Abstract class for Expressions without any arguments.
 * <p>
 * Created by covers1624 on 25/2/21.
 */
public abstract class SimpleInstruction extends Instruction {

    protected SimpleInstruction(InsnOpcode kind) {
        super(kind);
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }
}
