package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 6/7/21.
 */
public class Synchronized extends Instruction {

    private final InstructionSlot<Instruction> variable = new InstructionSlot<>(this);
    private final InstructionSlot<BlockContainer> body = new InstructionSlot<>(this);

    public Synchronized(Instruction variable, BlockContainer body) {
        super(InsnOpcode.SYNCHRONIZED);
        this.variable.set(variable);
        this.body.set(body);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitSynchronized(this, ctx);
    }

    public Instruction getVariable() {
        return variable.get();
    }

    public BlockContainer getBody() {
        return body.get();
    }

    public void setVariable(Instruction variable) {
        this.variable.set(variable);
    }

    public void setBody(BlockContainer body) {
        this.body.set(body);
    }
}
