/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.LinkedList;
import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.TryCatch;
import net.covers1624.coffeegrinder.bytecode.insns.TryFinally;
import net.covers1624.coffeegrinder.bytecode.insns.TryWithResources;
import net.covers1624.coffeegrinder.bytecode.matching.BlockMatching;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.matching.ComparisonMatching;
import net.covers1624.coffeegrinder.bytecode.matching.IfMatching;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.matching.TryCatchMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.TypeSystem;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class LegacyTryWithResourcesTransform
implements MethodTransformer {
    private static final Type AUTO_CLOSEABLE = Type.getType(AutoCloseable.class);
    private final ClassType autoCloseableClass;

    public LegacyTryWithResourcesTransform(TypeResolver typeResolver) {
        this.autoCloseableClass = typeResolver.resolveClass(AUTO_CLOSEABLE);
    }

    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        boolean done = false;
        block0: while (!done) {
            done = true;
            LinkedList tryFinallys = function.descendantsToList(InsnOpcode.TRY_FINALLY);
            for (TryFinally tryFinally : tryFinallys) {
                if (!this.transformTryWithResources(tryFinally, ctx)) continue;
                done = false;
                continue block0;
            }
        }
    }

    private boolean transformTryWithResources(TryFinally tryFinally, MethodTransformContext ctx) {
        Store synExceptionStore = LegacyTryWithResourcesTransform.matchStoreNull(tryFinally.getPrevSiblingOrNull());
        if (synExceptionStore == null) {
            return false;
        }
        LocalVariable synException = synExceptionStore.getVariable();
        if (!synException.isSynthetic() || synException.getLoadCount() != 2 || synException.getStoreCount() != 2) {
            return false;
        }
        Store autoCloseableStore = LoadStoreMatching.matchStoreLocal(synExceptionStore.getPrevSiblingOrNull());
        if (autoCloseableStore == null) {
            return false;
        }
        LocalVariable autoCloseable = autoCloseableStore.getVariable();
        if (!TypeSystem.isAssignableTo(autoCloseableStore.getResultType(), (AType)this.autoCloseableClass)) {
            return false;
        }
        BlockContainer tryFinallyBody = tryFinally.getTryBody();
        if (tryFinallyBody.blocks.size() != 1) {
            return false;
        }
        Block tryFinallyBodyEntryPoint = tryFinallyBody.getEntryPoint();
        if (tryFinallyBodyEntryPoint.instructions.size() != 1 && tryFinallyBodyEntryPoint.instructions.size() != 2) {
            return false;
        }
        TryCatch rethrowTry = TryCatchMatching.matchTryCatch(tryFinallyBodyEntryPoint.getFirstChild());
        if (rethrowTry == null) {
            return false;
        }
        if (rethrowTry.handlers.size() != 1) {
            return false;
        }
        if (tryFinallyBodyEntryPoint.instructions.size() == 2 && BranchLeaveMatching.matchLeave(tryFinallyBodyEntryPoint.getLastChild(), tryFinallyBody) == null) {
            return false;
        }
        TryCatch.TryCatchHandler rethrowCatch = (TryCatch.TryCatchHandler)rethrowTry.handlers.first();
        BlockContainer rethrowCatchBody = rethrowCatch.getBody();
        if (rethrowCatchBody.blocks.size() != 1) {
            return false;
        }
        Block rethrowCatchEntry = rethrowCatchBody.getEntryPoint();
        if (rethrowCatchEntry.instructions.size() != 2) {
            return false;
        }
        if (LoadStoreMatching.matchStoreLocalLoadLocal(rethrowCatchEntry.getFirstChild(), rethrowCatch.getVariable().variable) == null) {
            return false;
        }
        if (BranchLeaveMatching.matchThrow(rethrowCatchEntry.getLastChild(), rethrowCatch.getVariable().variable) == null) {
            return false;
        }
        BlockContainer finallyBody = tryFinally.getFinallyBody();
        if (finallyBody.blocks.size() != 1) {
            return false;
        }
        Block finallyBodyEntryPoint = finallyBody.getEntryPoint();
        if (finallyBodyEntryPoint.instructions.size() != 2) {
            return false;
        }
        IfInstruction autoCloseableIf = IfMatching.matchNopFalseIf(finallyBodyEntryPoint.getFirstChild());
        if (autoCloseableIf == null) {
            return false;
        }
        if (BranchLeaveMatching.matchLeave(autoCloseableIf.getNextSibling(), finallyBody) == null) {
            return false;
        }
        if (ComparisonMatching.matchNotEqualNull(autoCloseableIf.getCondition(), autoCloseable) == null) {
            return false;
        }
        IfInstruction synExceptionIf = IfMatching.matchIf(BlockMatching.getBlockOnlyChild(autoCloseableIf.getTrueInsn()));
        if (synExceptionIf == null) {
            return false;
        }
        if (ComparisonMatching.matchNotEqualNull(synExceptionIf.getCondition(), synException) == null) {
            return false;
        }
        if (!this.matchAutoCloseableCloseInvoke(BlockMatching.getBlockOnlyChild(synExceptionIf.getFalseInsn()), autoCloseable)) {
            return false;
        }
        TryCatch closeTryCatch = TryCatchMatching.matchTryCatch(BlockMatching.getBlockOnlyChild(synExceptionIf.getTrueInsn()));
        if (closeTryCatch == null) {
            return false;
        }
        if (closeTryCatch.handlers.size() != 1) {
            return false;
        }
        BlockContainer closeTCBody = closeTryCatch.getTryBody();
        if (closeTCBody.blocks.size() != 1) {
            return false;
        }
        Block closeTCBodyEntryPoint = closeTCBody.getEntryPoint();
        if (closeTCBodyEntryPoint.instructions.size() != 2) {
            return false;
        }
        if (!this.matchAutoCloseableCloseInvoke(closeTCBodyEntryPoint.getFirstChild(), autoCloseable)) {
            return false;
        }
        if (BranchLeaveMatching.matchLeave(closeTCBodyEntryPoint.getLastChild(), closeTCBody) == null) {
            return false;
        }
        TryCatch.TryCatchHandler closeCatch = (TryCatch.TryCatchHandler)closeTryCatch.handlers.first();
        BlockContainer closeCatchBody = closeCatch.getBody();
        if (closeCatchBody.blocks.size() != 1) {
            return false;
        }
        Block closeCatchBodyEntryPoint = closeCatchBody.getEntryPoint();
        if (closeCatchBodyEntryPoint.instructions.size() != 2) {
            return false;
        }
        Invoke invoke = InvokeMatching.matchInvoke(closeCatchBodyEntryPoint.getFirstChild(), Invoke.InvokeKind.VIRTUAL, "addSuppressed");
        if (invoke == null) {
            return false;
        }
        if (invoke.getArguments().size() != 1) {
            return false;
        }
        if (LoadStoreMatching.matchLoadLocal(invoke.getTarget(), synException) == null) {
            return false;
        }
        if (LoadStoreMatching.matchLoadLocal((Instruction)invoke.getArguments().first(), closeCatch.getVariable().variable) == null) {
            return false;
        }
        if (BranchLeaveMatching.matchLeave(closeCatchBodyEntryPoint.getLastChild(), closeCatchBody) == null) {
            return false;
        }
        ctx.pushStep("produce try-with-resources");
        tryFinally.replaceWith(new TryWithResources(autoCloseableStore, rethrowTry.getTryBody()));
        synExceptionStore.remove();
        ctx.popStep();
        return true;
    }

    @Nullable
    public static Store matchStoreNull(@Nullable Instruction insn) {
        Store store = LoadStoreMatching.matchStoreLocal(insn);
        if (store == null) {
            return null;
        }
        if (store.getValue().opcode != InsnOpcode.LDC_NULL) {
            return null;
        }
        return store;
    }

    private boolean matchAutoCloseableCloseInvoke(@Nullable Instruction insn, LocalVariable autoCloseable) {
        Invoke invoke = InvokeMatching.matchInvoke(insn);
        if (invoke == null) {
            return false;
        }
        if (LoadStoreMatching.matchLoadLocal(invoke.getTarget(), autoCloseable) == null) {
            return false;
        }
        if (invoke.getKind() != Invoke.InvokeKind.VIRTUAL && invoke.getKind() != Invoke.InvokeKind.INTERFACE) {
            return false;
        }
        if (!invoke.getMethod().getName().equals("close")) {
            return false;
        }
        return invoke.getMethod().getParameters().isEmpty();
    }
}

