package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;

/**
 * Created by covers1624 on 31/8/21.
 */
public class LoadThis extends SimpleInstruction {

    private final ClassType type;

    public LoadThis(ClassType type) {
        super(InsnOpcode.LOAD_THIS);
        this.type = type;
    }

    @Override
    public AType getResultType() {
        return type;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitLoadThis(this, ctx);
    }

    @Override
    public LoadThis copy() {
        return new LoadThis(type);
    }

    public ClassType getType() {
        return type;
    }
}
