package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.type.AType;

/**
 * Created by covers1624 on 5/4/21.
 */
public class PostIncrement extends SimpleInstruction {

    private final InstructionSlot<Reference> reference = new InstructionSlot<>(this);
    private final boolean positive;

    public PostIncrement(Reference reference, boolean positive) {
        super(InsnOpcode.POST_INCREMENT);
        this.reference.set(reference);
        this.positive = positive;
    }

    @Override
    public AType getResultType() {
        return getReference().getType();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitPostIncrement(this, ctx);
    }

    @Override
    protected void onChildModified() {
        super.onChildModified();
        if (isConnected()) {
            getReference().setReadFrom(true);
            getReference().setWrittenTo(true);
        }
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        getReference().setReadFrom(true);
        getReference().setWrittenTo(true);
    }

    public boolean isPositive() {
        return positive;
    }

    public Reference getReference() {
        return reference.get();
    }

}
