package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 6/12/22.
 */
public class Return extends Instruction {

    private final InstructionSlot<Instruction> value = new InstructionSlot<>(this);

    private final MethodDecl method;

    public Return(MethodDecl method) {
        this(method, new Nop());
    }

    public Return(MethodDecl method, Instruction value) {
        super(InsnOpcode.RETURN);
        this.method = method;
        this.value.set(value);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.END_POINT_UNREACHABLE.toSet();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitReturn(this, ctx);
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        method.addReturn(this);
    }

    @Override
    protected void onDisconnected() {
        super.onDisconnected();
        method.removeReturn(this);
    }

    public Instruction getValue() {
        return value.get();
    }

    public MethodDecl getMethod() {
        return method;
    }
}
