package net.covers1624.coffeegrinder.bytecode.matching;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import org.jetbrains.annotations.Nullable;

/**
 * Created by covers1624 on 9/9/21.
 */
public class BlockMatching {

    /**
     * Matches the provided Instruction against a {@link Block} instruction.
     *
     * @param insn The Instruction to match.
     * @return The {@link Block} or <code>null</code>.
     */
    @Nullable
    public static Block matchBlock(@Nullable Instruction insn) {
        if (insn == null || insn.opcode != InsnOpcode.BLOCK) return null;

        return (Block) insn;
    }

    /**
     * Matches the provided instruction against a {@link Block} which has a single
     * child.
     *
     * @param insn The Instruction to match.
     * @return The single child instruction of the matched {@link Block} or <code>null</code>.
     */
    @Nullable
    public static Instruction getBlockOnlyChild(@Nullable Instruction insn) {
        Block block = matchBlock(insn);
        if (block == null) return null;
        return block.instructions.onlyOrDefault();
    }
}
