package net.covers1624.coffeegrinder.bytecode.matching;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Throw;
import net.covers1624.coffeegrinder.bytecode.insns.TryCatch;
import net.covers1624.coffeegrinder.bytecode.insns.TryFinally;
import org.jetbrains.annotations.Nullable;

/**
 * Created by covers1624 on 20/6/21.
 */
public class TryCatchMatching {

    /**
     * Matches a single {@link TryCatch} instruction.
     *
     * @param insn The instruction to match.
     * @return The {@link TryCatch} instruction or null.
     */
    @Nullable
    public static TryCatch matchTryCatch(@Nullable Instruction insn) {
        if (!(insn instanceof TryCatch)) return null;
        return (TryCatch) insn;
    }

    /**
     * Matches a single {@link TryFinally} instruction.
     *
     * @param insn The instruction to match.
     * @return The {@link TryFinally} instruction or null.
     */
    @Nullable
    public static TryFinally matchTryFinally(@Nullable Instruction insn) {
        if (!(insn instanceof TryFinally)) return null;
        return (TryFinally) insn;
    }

    /**
     * Matches a single {@link Throw} instruction.
     *
     * @param insn The instruction to match.
     * @return The {@link Throw} instruction or null.
     */
    @Nullable
    public static Throw matchThrow(@Nullable Instruction insn) {
        if (!(insn instanceof Throw)) return null;
        return (Throw) insn;
    }
}
