package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.insns.*;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;

import java.util.List;

import static net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching.matchLeave;

/**
 * Created by covers1624 on 11/8/21.
 */
public class SwitchInlining implements MethodTransformer {

    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {

        List<Switch> switches = function.descendantsToList(InsnOpcode.SWITCH);

        for (Switch aSwitch : switches) {
            BlockContainer switchContainer = aSwitch.getBody();
            ctx.pushStep("Inline switch sections " + switchContainer.getEntryPoint().getName());

            for (SwitchTable.SwitchSection section : aSwitch.getSwitchTable().sections) {
                SwitchTable.SwitchSection nextSibling = (SwitchTable.SwitchSection) section.getNextSiblingOrNull();

                if (section.getBody().opcode != InsnOpcode.BRANCH) {
                    if (section.values.size() == 1 && section.values.first().opcode == InsnOpcode.NOP
                            && matchLeave(section.getBody(), switchContainer) != null) {
                        ctx.pushStep("Remove redundant default case");
                        section.remove();
                        ctx.popStep();
                    }
                    continue;
                }

                Branch branch = (Branch) section.getBody();
                Block target = branch.getTargetBlock();
                if (target.getIncomingEdgeCount() != 1) continue;

                branch.replaceWith(target);
                if (nextSibling == null) continue;

                Branch lastBranch = BranchLeaveMatching.matchBranch(target.instructions.last());
                if (lastBranch == null || BranchLeaveMatching.matchBranch(nextSibling.getBody(), lastBranch.getTargetBlock()) == null) continue;
                lastBranch.remove();
            }

            ctx.popStep();
        }
    }
}
