package net.covers1624.coffeegrinder.bytecode.transform.transformers.statement;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.New;
import net.covers1624.coffeegrinder.bytecode.insns.NewObject;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;
import net.covers1624.coffeegrinder.type.ClassType;

/**
 * Created by covers1624 on 8/9/21.
 */
public class NewObjectTransform implements StatementTransformer {

    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        // STORE(s_1, NEW_OBJECT type)
        // INVOKE.SPECIAL ...
        // ->
        // STORE(s_1, NEW(...))
        Store store = LoadStoreMatching.matchStoreLocal(statement);
        if (store == null || store.getValue().opcode != InsnOpcode.NEW_OBJECT) return;

        Invoke invoke = InvokeMatching.matchInvoke(store.getNextSiblingOrNull(), Invoke.InvokeKind.SPECIAL);
        if (invoke == null) return;

        ClassType type = (ClassType) ((NewObject) store.getValue()).getType();

        ctx.pushStep("Inline new");
        store.getValue().replaceWith(new New(type, invoke.getMethod(), invoke.getArguments()));
        invoke.remove();
        ctx.popStep();
    }
}
