package net.covers1624.coffeegrinder.type;

/**
 * Created by covers1624 on 23/7/21.
 */
public class IntegerConstantType extends AType {

    private final int value;

    public IntegerConstantType(int value) {
        this.value = value;
    }

    @Override
    public String getName() {
        return "int_constant(" + value + ")";
    }

    public int getValue() {
        return value;
    }

    @Override
    public int hashCode() {
        return value;
    }

    @Override
    public String toString() {
        return "IntegerConstantType(" + value + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof IntegerConstantType)) return false;
        IntegerConstantType other = (IntegerConstantType) o;

        return getValue() == other.getValue();
    }
}
