package net.covers1624.coffeegrinder.type.accessors;

import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.Method;

/**
 * Created by covers1624 on 5/7/22.
 */
public abstract class SyntheticAccessor {

    public final AccessorType type;

    protected SyntheticAccessor(AccessorType type) {
        this.type = type;
    }

    public enum AccessorType {
        INVOKE,
        FIELD_LOAD,
        FIELD_STORE,
        FIELD_POST_INC,
        FIELD_PRE_INC,
        CONSTRUCTOR,
    }

    public static class MethodAccessor extends SyntheticAccessor {

        public final Method method;

        public MethodAccessor(AccessorType type, Method method) {
            super(type);
            this.method = method;
        }
    }

    public static class FieldAccessor extends SyntheticAccessor {

        public final Field field;

        public FieldAccessor(AccessorType type, Field field) {
            super(type);
            this.field = field;
        }
    }

    public static class FieldIncrementAccessor extends FieldAccessor {

        public final boolean positive;

        public FieldIncrementAccessor(AccessorType type, Field field, boolean positive) {
            super(type, field);
            this.positive = positive;
        }
    }

    public static class CtorAccessor extends MethodAccessor {

        public final ClassType deadSyntheticClass;

        public CtorAccessor(Method method, ClassType deadSyntheticClass) {
            super(AccessorType.CONSTRUCTOR, method);
            this.deadSyntheticClass = deadSyntheticClass;
        }
    }
}
