package net.covers1624.coffeegrinder.util.asm;

import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;

/**
 * A custom {@link InsnList} aware of our {@link NodeAwareMethodVisitor}.
 * <p>
 * Created by covers1624 on 4/4/21.
 */
public class CustomInsnList extends InsnList {

    public CustomInsnList(InsnList other) {
        insert(other);
    }

    @Override
    public void resetLabels() {
        // No!
    }

    @Override
    public void accept(MethodVisitor methodVisitor) {
        if (!(methodVisitor instanceof NodeAwareMethodVisitor)) {
            super.accept(methodVisitor);
            return;
        }
        NodeAwareMethodVisitor mv = (NodeAwareMethodVisitor) methodVisitor;
        AbstractInsnNode currentInsn = getFirst();
        while (currentInsn != null) {
            mv.visitInsn(currentInsn, indexOf(currentInsn));
            currentInsn = currentInsn.getNext();
        }
    }
}
