package net.covers1624.coffeegrinder.util.resolver;

import java.nio.file.Files;
import java.nio.file.Path;

/**
 * A {@link Resolver} capable of reading things from a folder.
 * <p>
 * Created by covers1624 on 8/4/21.
 */
public class FolderResolver extends AbstractPathResolver {

    public FolderResolver(Path path) {
        super(path);
    }

    @Override
    protected void validate() {
        if (Files.notExists(path)) throw new IllegalStateException("File does not exist.");
        if (!Files.isDirectory(path)) throw new IllegalStateException("Not a directory.");
    }

    @Override
    public String toString() {
        return "FolderResolver(" + path + ")";
    }
}
