package net.covers1624.coffeegrinder.util.resolver;

import net.covers1624.quack.io.IOUtils;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;

/**
 * A {@link Resolver} capable of reading things from a zip/jar file.
 * <p>
 * Created by covers1624 on 8/4/21.
 */
public class JarResolver extends AbstractPathResolver {

    protected final FileSystem fs;
    private final Path rootFolder;

    public JarResolver(Path path) {
        this(path, "/");
    }

    public JarResolver(Path path, String rootPath) {
        super(path);

        try {
            fs = IOUtils.getJarFileSystem(path, false);
        } catch (IOException e) {
            throw new RuntimeException("Failed to create FileSystem.", e);
        }
        rootFolder = fs.getPath(rootPath);
    }

    @Override
    protected void validate() {
        if (Files.notExists(path)) throw new IllegalStateException("File does not exist.");
        if (!Files.isRegularFile(path)) throw new IllegalStateException("Not a file.");
        String fName = path.getFileName().toString();
        if (!fName.endsWith(".jar") && !fName.endsWith(".zip")) throw new IllegalStateException("Expected zip or jar file extension.");
    }

    @Override
    protected Path getRootPath() {
        return rootFolder;
    }

    @Override
    public void close() throws IOException {
        fs.close();
    }

    @Override
    public String toString() {
        return "JarResolver(" + path + ")";
    }
}
