/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.testengine.testcase;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.covers1624.coffeegrinder.testengine.api.Target;
import net.covers1624.coffeegrinder.testengine.testcase.DecompileTestCaseEngine;
import net.covers1624.coffeegrinder.testengine.testcase.TestCase;
import net.covers1624.coffeegrinder.testengine.testcase.TestCaseEngineDescriptor;
import net.covers1624.coffeegrinder.testengine.testcase.util.InputPath;
import net.covers1624.coffeegrinder.testengine.testcase.util.LibraryTestCaseDef;
import net.covers1624.coffeegrinder.testengine.testcase.util.OuterClassExtractor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class LibraryTestCaseEngine
extends DecompileTestCaseEngine {
    public LibraryTestCaseEngine() {
        super("testcase-library-engine", "coffeegrinder.testcases.library");
    }

    @Override
    protected List<TestCase> locateTests(TestCaseEngineDescriptor ctx) throws IOException {
        LibraryTestCaseDef testCaseDefs;
        ctx.libraryDefs = testCaseDefs = LibraryTestCaseDef.load(ctx.getOptionalPathConfig("coffeegrinder.test.defs"));
        LinkedList<TestCase> testCases = new LinkedList<TestCase>();
        for (Path path : ctx.inputClassPaths.allFiles()) {
            if (!path.getFileName().toString().endsWith(".class")) continue;
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            Throwable throwable = null;
            try {
                ClassReader reader = new ClassReader(is);
                if (reader.getClassName().equals("module-info") || !LibraryTestCaseEngine.isTopLevelDecl(reader, ctx.inputClassPaths)) continue;
                String cName = reader.getClassName();
                LibraryTestCaseDef.TestCaseDef def = testCaseDefs.get(cName);
                HashMap<String, Map<String, String>> roundTripIgnores = new HashMap<String, Map<String, String>>();
                if (def.roundTripIgnore != null) {
                    def.roundTripIgnore.forEach((name, reason) -> {
                        String clsName = cName;
                        int dot = name.indexOf(46);
                        if (dot != -1) {
                            String inner = name.substring(0, dot);
                            name = name.substring(dot + 1);
                            clsName = !inner.startsWith(clsName) ? clsName + inner : inner;
                        }
                        roundTripIgnores.computeIfAbsent(clsName, e -> new LinkedHashMap()).put(name, reason);
                    });
                }
                testCases.add(new TestCase(cName.replace('/', '.'), def.target != null ? def.target : Target.BYTECODE_ROUND_TRIP, def.broken != null ? def.broken.buildData() : null, roundTripIgnores));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        return testCases;
    }

    @Override
    protected void postProcess(TestCaseEngineDescriptor root) throws IOException {
        Path statsPath = root.getOptionalPathConfig("coffeegrinder.test.stats");
        if (statsPath != null) {
            LibraryTestCaseEngine.toDefs(root.tests(), false).save(statsPath);
        }
        Path defsPath = root.getOptionalPathConfig("coffeegrinder.test.defs");
        if (root.updateLibraryDefs && defsPath != null) {
            LibraryTestCaseEngine.toDefs(root.tests(), true).save(defsPath);
        }
    }

    private static LibraryTestCaseDef toDefs(List<TestCase> tests, boolean brief) {
        LibraryTestCaseDef def = new LibraryTestCaseDef();
        for (TestCase test : tests) {
            String cName = test.className.replace('.', '/');
            LibraryTestCaseDef.TestCaseDef caseDef = LibraryTestCaseEngine.toDef(test, cName, brief);
            if (brief) {
                if (caseDef.target == Target.BYTECODE_ROUND_TRIP) {
                    caseDef.target = null;
                }
                if (LibraryTestCaseEngine.isRedundant(caseDef)) continue;
            }
            def.cases.put(cName, caseDef);
        }
        return def;
    }

    private static boolean isRedundant(LibraryTestCaseDef.TestCaseDef def) {
        return def.target == null && def.broken == null && def.roundTripIgnore == null;
    }

    private static LibraryTestCaseDef.TestCaseDef toDef(TestCase test, String cName, boolean brief) {
        LibraryTestCaseDef.TestCaseDef caseDef = new LibraryTestCaseDef.TestCaseDef();
        if (test.processingError != null) {
            caseDef.target = null;
            caseDef.broken = new LibraryTestCaseDef.BrokenDef();
            caseDef.broken.exception = test.processingError.expected.getName();
            caseDef.broken.message = test.processingError.message;
            if (!brief && test.processingError.stackTrace != null) {
                caseDef.broken.stackTrace = test.processingError.stackTrace.replace("\t", "    ").split("\n");
            }
        } else {
            caseDef.target = test.reachedTarget;
        }
        if (!test.appliedRoundTripIgnores.isEmpty()) {
            LinkedHashMap<String, String> rtIgnores = new LinkedHashMap<String, String>();
            test.appliedRoundTripIgnores.forEach((clsName, ignores) -> ignores.forEach((name, reason) -> {
                if (!clsName.equals(cName)) {
                    name = clsName + "." + name;
                }
                rtIgnores.put((String)name, (String)reason);
            }));
            if (!rtIgnores.isEmpty()) {
                caseDef.roundTripIgnore = rtIgnores;
            }
        }
        return caseDef;
    }

    private static boolean isTopLevelDecl(ClassReader reader, InputPath rootFs) {
        int lastDollar;
        OuterClassExtractor outerClassExtractor = new OuterClassExtractor();
        reader.accept((ClassVisitor)outerClassExtractor, 1);
        String cName = reader.getClassName();
        String outerName = outerClassExtractor.outerClass;
        if (outerName == null && (lastDollar = cName.lastIndexOf("$")) != -1) {
            outerName = cName.substring(0, lastDollar);
        }
        return outerName == null || !rootFs.exists(outerName);
    }

    private static String getCName(Path clazzPath) throws IOException {
        try (InputStream is = Files.newInputStream(clazzPath, new OpenOption[0]);){
            String string = new ClassReader(is).getClassName();
            return string;
        }
    }
}

