/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.io.PrintWriter;
import org.junit.platform.console.options.BaseCommand;
import org.junit.platform.console.options.TestConsoleOutputOptions;
import org.junit.platform.console.options.TestConsoleOutputOptionsMixin;
import org.junit.platform.console.options.TestDiscoveryOptions;
import org.junit.platform.console.options.TestDiscoveryOptionsMixin;
import org.junit.platform.console.shadow.picocli.CommandLine;
import org.junit.platform.console.tasks.ConsoleTestExecutor;

@CommandLine.Command(name="discover", description={"Discover tests"})
class DiscoverTestsCommand
extends BaseCommand<Void> {
    private final ConsoleTestExecutor.Factory consoleTestExecutorFactory;
    @CommandLine.Mixin
    TestDiscoveryOptionsMixin discoveryOptions;
    @CommandLine.Mixin
    TestConsoleOutputOptionsMixin testOutputOptions;

    DiscoverTestsCommand(ConsoleTestExecutor.Factory consoleTestExecutorFactory) {
        this.consoleTestExecutorFactory = consoleTestExecutorFactory;
    }

    @Override
    protected Void execute(PrintWriter out) {
        TestDiscoveryOptions discoveryOptions = this.discoveryOptions.toTestDiscoveryOptions();
        TestConsoleOutputOptions testOutputOptions = this.testOutputOptions.toTestConsoleOutputOptions();
        testOutputOptions.setAnsiColorOutputDisabled(this.ansiColorOption.isDisableAnsiColors());
        this.consoleTestExecutorFactory.create(discoveryOptions, testOutputOptions).discover(out);
        return null;
    }
}

