/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public class Ternary
extends Instruction {
    private final InstructionSlot<Instruction> condition = new InstructionSlot(this);
    private final InstructionSlot<Instruction> trueInsn = new InstructionSlot(this);
    private final InstructionSlot<Instruction> falseInsn = new InstructionSlot(this);

    public Ternary(Instruction condition, Instruction trueInsn, Instruction falseInsn) {
        super(InsnOpcode.TERNARY);
        this.condition.set(condition);
        this.trueInsn.set(trueInsn);
        this.falseInsn.set(falseInsn);
    }

    @Override
    public AType getResultType() {
        return Ternary.getResultType(this.getTrueInsn().getResultType(), this.getFalseInsn().getResultType());
    }

    private static AType getResultType(AType a, AType b) {
        if (TypeSystem.isAssignableTo(a, b)) {
            return b;
        }
        if (TypeSystem.isAssignableTo(b, a)) {
            return a;
        }
        if (a instanceof ReferenceType) {
            return TypeSystem.lub((ReferenceType)a, (ReferenceType)b);
        }
        return PrimitiveType.INT;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitTernary(this, ctx);
    }

    public Instruction getCondition() {
        return this.condition.get();
    }

    public Instruction getTrueInsn() {
        return this.trueInsn.get();
    }

    public Instruction getFalseInsn() {
        return this.falseInsn.get();
    }
}

